/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public class ShaderInstance
implements Shader,
AutoCloseable {
    public static final String SHADER_PATH = "shaders";
    private static final String SHADER_CORE_PATH = "shaders/core/";
    private static final String SHADER_INCLUDE_PATH = "shaders/include/";
    static final Logger LOGGER = LogUtils.getLogger();
    private static final AbstractUniform DUMMY_UNIFORM = new AbstractUniform();
    private static final boolean ALWAYS_REAPPLY = true;
    private static ShaderInstance lastAppliedShader;
    private static int lastProgramId;
    private final Map<String, Object> samplerMap = Maps.newHashMap();
    private final List<String> samplerNames = Lists.newArrayList();
    private final List<Integer> samplerLocations = Lists.newArrayList();
    private final List<Uniform> uniforms = Lists.newArrayList();
    private final List<Integer> uniformLocations = Lists.newArrayList();
    private final Map<String, Uniform> uniformMap = Maps.newHashMap();
    private final int programId;
    private final String name;
    private boolean dirty;
    private final Program vertexProgram;
    private final Program fragmentProgram;
    private final VertexFormat vertexFormat;
    @Nullable
    public final Uniform MODEL_VIEW_MATRIX;
    @Nullable
    public final Uniform PROJECTION_MATRIX;
    @Nullable
    public final Uniform TEXTURE_MATRIX;
    @Nullable
    public final Uniform SCREEN_SIZE;
    @Nullable
    public final Uniform COLOR_MODULATOR;
    @Nullable
    public final Uniform LIGHT0_DIRECTION;
    @Nullable
    public final Uniform LIGHT1_DIRECTION;
    @Nullable
    public final Uniform GLINT_ALPHA;
    @Nullable
    public final Uniform FOG_START;
    @Nullable
    public final Uniform FOG_END;
    @Nullable
    public final Uniform FOG_COLOR;
    @Nullable
    public final Uniform FOG_SHAPE;
    @Nullable
    public final Uniform LINE_WIDTH;
    @Nullable
    public final Uniform GAME_TIME;
    @Nullable
    public final Uniform CHUNK_OFFSET;

    public ShaderInstance(ResourceProvider p_173336_, String p_173337_, VertexFormat p_173338_) throws IOException {
        this.name = p_173337_;
        this.vertexFormat = p_173338_;
        ResourceLocation $$3 = ResourceLocation.withDefaultNamespace(SHADER_CORE_PATH + p_173337_ + ".json");
        try (BufferedReader $$4 = p_173336_.openAsReader($$3);){
            JsonArray $$13;
            JsonObject $$5 = GsonHelper.parse($$4);
            String $$6 = GsonHelper.getAsString($$5, "vertex");
            String $$7 = GsonHelper.getAsString($$5, "fragment");
            JsonArray $$8 = GsonHelper.getAsJsonArray($$5, "samplers", null);
            if ($$8 != null) {
                int $$9 = 0;
                for (JsonElement $$10 : $$8) {
                    try {
                        this.parseSamplerNode($$10);
                    }
                    catch (Exception $$11) {
                        ChainedJsonException $$12 = ChainedJsonException.forException($$11);
                        $$12.prependJsonKey("samplers[" + $$9 + "]");
                        throw $$12;
                    }
                    ++$$9;
                }
            }
            if (($$13 = GsonHelper.getAsJsonArray($$5, "uniforms", null)) != null) {
                int $$14 = 0;
                for (JsonElement $$15 : $$13) {
                    try {
                        this.parseUniformNode($$15);
                    }
                    catch (Exception $$16) {
                        ChainedJsonException $$17 = ChainedJsonException.forException($$16);
                        $$17.prependJsonKey("uniforms[" + $$14 + "]");
                        throw $$17;
                    }
                    ++$$14;
                }
            }
            this.vertexProgram = ShaderInstance.getOrCreate(p_173336_, Program.Type.VERTEX, $$6);
            this.fragmentProgram = ShaderInstance.getOrCreate(p_173336_, Program.Type.FRAGMENT, $$7);
            this.programId = ProgramManager.createProgram();
            int $$18 = 0;
            for (String $$19 : p_173338_.getElementAttributeNames()) {
                Uniform.glBindAttribLocation(this.programId, $$18, $$19);
                ++$$18;
            }
            ProgramManager.linkShader(this);
            this.updateLocations();
        }
        catch (Exception $$21) {
            ChainedJsonException $$22 = ChainedJsonException.forException($$21);
            $$22.setFilenameAndFlush($$3.getPath());
            throw $$22;
        }
        this.markDirty();
        this.MODEL_VIEW_MATRIX = this.getUniform("ModelViewMat");
        this.PROJECTION_MATRIX = this.getUniform("ProjMat");
        this.TEXTURE_MATRIX = this.getUniform("TextureMat");
        this.SCREEN_SIZE = this.getUniform("ScreenSize");
        this.COLOR_MODULATOR = this.getUniform("ColorModulator");
        this.LIGHT0_DIRECTION = this.getUniform("Light0_Direction");
        this.LIGHT1_DIRECTION = this.getUniform("Light1_Direction");
        this.GLINT_ALPHA = this.getUniform("GlintAlpha");
        this.FOG_START = this.getUniform("FogStart");
        this.FOG_END = this.getUniform("FogEnd");
        this.FOG_COLOR = this.getUniform("FogColor");
        this.FOG_SHAPE = this.getUniform("FogShape");
        this.LINE_WIDTH = this.getUniform("LineWidth");
        this.GAME_TIME = this.getUniform("GameTime");
        this.CHUNK_OFFSET = this.getUniform("ChunkOffset");
    }

    private static Program getOrCreate(final ResourceProvider p_173341_, Program.Type p_173342_, String p_173343_) throws IOException {
        Program $$10;
        Program $$3 = p_173342_.getPrograms().get(p_173343_);
        if ($$3 == null) {
            String $$4 = SHADER_CORE_PATH + p_173343_ + p_173342_.getExtension();
            Resource $$5 = p_173341_.getResourceOrThrow(ResourceLocation.withDefaultNamespace($$4));
            try (InputStream $$6 = $$5.open();){
                final String $$7 = FileUtil.getFullResourcePath($$4);
                Program $$8 = Program.compileShader(p_173342_, p_173343_, $$6, $$5.sourcePackId(), new GlslPreprocessor(){
                    private final Set<String> importedPaths = Sets.newHashSet();

                    @Override
                    public String applyImport(boolean p_173374_, String p_173375_) {
                        String string;
                        block9: {
                            p_173375_ = FileUtil.normalizeResourcePath((p_173374_ ? $$7 : ShaderInstance.SHADER_INCLUDE_PATH) + p_173375_);
                            if (!this.importedPaths.add(p_173375_)) {
                                return null;
                            }
                            ResourceLocation $$2 = ResourceLocation.parse(p_173375_);
                            BufferedReader $$3 = p_173341_.openAsReader($$2);
                            try {
                                string = IOUtils.toString((Reader)$$3);
                                if ($$3 == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if ($$3 != null) {
                                        try {
                                            ((Reader)$$3).close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException $$4) {
                                    LOGGER.error("Could not open GLSL import {}: {}", (Object)p_173375_, (Object)$$4.getMessage());
                                    return "#error " + $$4.getMessage();
                                }
                            }
                            ((Reader)$$3).close();
                        }
                        return string;
                    }
                });
            }
        } else {
            $$10 = $$3;
        }
        return $$10;
    }

    @Override
    public void close() {
        for (Uniform $$0 : this.uniforms) {
            $$0.close();
        }
        ProgramManager.releaseProgram(this);
    }

    public void clear() {
        RenderSystem.assertOnRenderThread();
        ProgramManager.glUseProgram(0);
        lastProgramId = -1;
        lastAppliedShader = null;
        int $$0 = GlStateManager._getActiveTexture();
        for (int $$1 = 0; $$1 < this.samplerLocations.size(); ++$$1) {
            if (this.samplerMap.get(this.samplerNames.get($$1)) == null) continue;
            GlStateManager._activeTexture(33984 + $$1);
            GlStateManager._bindTexture(0);
        }
        GlStateManager._activeTexture($$0);
    }

    public void apply() {
        RenderSystem.assertOnRenderThread();
        this.dirty = false;
        lastAppliedShader = this;
        if (this.programId != lastProgramId) {
            ProgramManager.glUseProgram(this.programId);
            lastProgramId = this.programId;
        }
        int $$0 = GlStateManager._getActiveTexture();
        for (int $$1 = 0; $$1 < this.samplerLocations.size(); ++$$1) {
            String $$2 = this.samplerNames.get($$1);
            if (this.samplerMap.get($$2) == null) continue;
            int $$3 = Uniform.glGetUniformLocation(this.programId, $$2);
            Uniform.uploadInteger($$3, $$1);
            RenderSystem.activeTexture(33984 + $$1);
            Object $$4 = this.samplerMap.get($$2);
            int $$5 = -1;
            if ($$4 instanceof RenderTarget) {
                $$5 = ((RenderTarget)$$4).getColorTextureId();
            } else if ($$4 instanceof AbstractTexture) {
                $$5 = ((AbstractTexture)$$4).getId();
            } else if ($$4 instanceof Integer) {
                $$5 = (Integer)$$4;
            }
            if ($$5 == -1) continue;
            RenderSystem.bindTexture($$5);
        }
        GlStateManager._activeTexture($$0);
        for (Uniform $$6 : this.uniforms) {
            $$6.upload();
        }
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Nullable
    public Uniform getUniform(String p_173349_) {
        RenderSystem.assertOnRenderThread();
        return this.uniformMap.get(p_173349_);
    }

    public AbstractUniform safeGetUniform(String p_173357_) {
        Uniform $$1 = this.getUniform(p_173357_);
        return $$1 == null ? DUMMY_UNIFORM : $$1;
    }

    private void updateLocations() {
        RenderSystem.assertOnRenderThread();
        IntArrayList $$0 = new IntArrayList();
        for (int $$1 = 0; $$1 < this.samplerNames.size(); ++$$1) {
            String $$2 = this.samplerNames.get($$1);
            int $$3 = Uniform.glGetUniformLocation(this.programId, $$2);
            if ($$3 == -1) {
                LOGGER.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.name, (Object)$$2);
                this.samplerMap.remove($$2);
                $$0.add($$1);
                continue;
            }
            this.samplerLocations.add($$3);
        }
        for (int $$4 = $$0.size() - 1; $$4 >= 0; --$$4) {
            int $$5 = $$0.getInt($$4);
            this.samplerNames.remove($$5);
        }
        for (Uniform $$6 : this.uniforms) {
            String $$7 = $$6.getName();
            int $$8 = Uniform.glGetUniformLocation(this.programId, $$7);
            if ($$8 == -1) {
                LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.name, (Object)$$7);
                continue;
            }
            this.uniformLocations.add($$8);
            $$6.setLocation($$8);
            this.uniformMap.put($$7, $$6);
        }
    }

    private void parseSamplerNode(JsonElement p_173345_) {
        JsonObject $$1 = GsonHelper.convertToJsonObject(p_173345_, "sampler");
        String $$2 = GsonHelper.getAsString($$1, "name");
        if (!GsonHelper.isStringValue($$1, "file")) {
            this.samplerMap.put($$2, null);
            this.samplerNames.add($$2);
            return;
        }
        this.samplerNames.add($$2);
    }

    public void setSampler(String p_173351_, Object p_173352_) {
        this.samplerMap.put(p_173351_, p_173352_);
        this.markDirty();
    }

    private void parseUniformNode(JsonElement p_173355_) throws ChainedJsonException {
        JsonObject $$1 = GsonHelper.convertToJsonObject(p_173355_, "uniform");
        String $$2 = GsonHelper.getAsString($$1, "name");
        int $$3 = Uniform.getTypeFromString(GsonHelper.getAsString($$1, "type"));
        int $$4 = GsonHelper.getAsInt($$1, "count");
        float[] $$5 = new float[Math.max($$4, 16)];
        JsonArray $$6 = GsonHelper.getAsJsonArray($$1, "values");
        if ($$6.size() != $$4 && $$6.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + $$4 + ", found " + $$6.size() + ")");
        }
        int $$7 = 0;
        for (JsonElement $$8 : $$6) {
            try {
                $$5[$$7] = GsonHelper.convertToFloat($$8, "value");
            }
            catch (Exception $$9) {
                ChainedJsonException $$10 = ChainedJsonException.forException($$9);
                $$10.prependJsonKey("values[" + $$7 + "]");
                throw $$10;
            }
            ++$$7;
        }
        if ($$4 > 1 && $$6.size() == 1) {
            while ($$7 < $$4) {
                $$5[$$7] = $$5[0];
                ++$$7;
            }
        }
        int $$11 = $$4 > 1 && $$4 <= 4 && $$3 < 8 ? $$4 - 1 : 0;
        Uniform $$12 = new Uniform($$2, $$3 + $$11, $$4, this);
        if ($$3 <= 3) {
            $$12.setSafe((int)$$5[0], (int)$$5[1], (int)$$5[2], (int)$$5[3]);
        } else if ($$3 <= 7) {
            $$12.setSafe($$5[0], $$5[1], $$5[2], $$5[3]);
        } else {
            $$12.set(Arrays.copyOfRange($$5, 0, $$4));
        }
        this.uniforms.add($$12);
    }

    @Override
    public Program getVertexProgram() {
        return this.vertexProgram;
    }

    @Override
    public Program getFragmentProgram() {
        return this.fragmentProgram;
    }

    @Override
    public void attachToProgram() {
        this.fragmentProgram.attachToShader(this);
        this.vertexProgram.attachToShader(this);
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.programId;
    }

    public void setDefaultUniforms(VertexFormat.Mode p_350497_, Matrix4f p_351053_, Matrix4f p_350556_, Window p_350876_) {
        for (int $$4 = 0; $$4 < 12; ++$$4) {
            int $$5 = RenderSystem.getShaderTexture($$4);
            this.setSampler("Sampler" + $$4, $$5);
        }
        if (this.MODEL_VIEW_MATRIX != null) {
            this.MODEL_VIEW_MATRIX.set(p_351053_);
        }
        if (this.PROJECTION_MATRIX != null) {
            this.PROJECTION_MATRIX.set(p_350556_);
        }
        if (this.COLOR_MODULATOR != null) {
            this.COLOR_MODULATOR.set(RenderSystem.getShaderColor());
        }
        if (this.GLINT_ALPHA != null) {
            this.GLINT_ALPHA.set(RenderSystem.getShaderGlintAlpha());
        }
        if (this.FOG_START != null) {
            this.FOG_START.set(RenderSystem.getShaderFogStart());
        }
        if (this.FOG_END != null) {
            this.FOG_END.set(RenderSystem.getShaderFogEnd());
        }
        if (this.FOG_COLOR != null) {
            this.FOG_COLOR.set(RenderSystem.getShaderFogColor());
        }
        if (this.FOG_SHAPE != null) {
            this.FOG_SHAPE.set(RenderSystem.getShaderFogShape().getIndex());
        }
        if (this.TEXTURE_MATRIX != null) {
            this.TEXTURE_MATRIX.set(RenderSystem.getTextureMatrix());
        }
        if (this.GAME_TIME != null) {
            this.GAME_TIME.set(RenderSystem.getShaderGameTime());
        }
        if (this.SCREEN_SIZE != null) {
            this.SCREEN_SIZE.set((float)p_350876_.getWidth(), (float)p_350876_.getHeight());
        }
        if (this.LINE_WIDTH != null && (p_350497_ == VertexFormat.Mode.LINES || p_350497_ == VertexFormat.Mode.LINE_STRIP)) {
            this.LINE_WIDTH.set(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights(this);
    }

    static {
        lastProgramId = -1;
    }
}

